#include <cstdio>
#include <cstring>
#include <algorithm>
#include <cassert>

using namespace std;

const int MAXN = 2010;
const int MODULO = 1000000000 + 7;

long long N;
long long D;
int X;
int sums[MAXN];
int d[MAXN][MAXN];
long long rev[MAXN];

void buildSums(int day) {
	sums[0] = d[day][0];
	for(int i = 1; i < MAXN; i++) {
		sums[i] = sums[i - 1] + d[day][i];
		if(sums[i] >= MODULO)
			sums[i] -= MODULO;
	}
}

inline int getSum(int l, int r) {
	int result = sums[r] - ((l == 0) ? 0 : sums[l - 1]);
	if(result < 0)
		result += MODULO;
	return result;
}

long long factorial(long long n) {
	long long result = 1;
	for(long long i = 2; i <= n; i++) {
		result *= i;
	}
	return result;
}

long long C(long long n, long long k) {
	assert(k < MAXN);
	long long start = n - k + 1;
	long long end = n;
	long long result = 1;
	for(long long i = start; i <= end; i++) {
		result = (result * i) % MODULO;
	}
	result = (result * rev[k]) % MODULO;
	return result;
}

void solve() {
	if(X == 1) {
		printf("0\n");
	} else {
		memset(d, 0, sizeof(d));
		d[0][0] = 1;
		for(int day = 1; day <= min(D, N); day++) {
			buildSums(day - 1);
			for(int already = 1; already <= N; already++) {
				int l = max(0, already - X + 1);
				int r = already - 1;
				assert(l <= r);
				d[day][already] = getSum(l, r);
			}
		}
		long long result = 0;
		for(int day = 1; day <= min(D, N); day++) {
			result += d[day][N] * C(D, day);
		}
		result %=  MODULO;
		printf("%d\n", result);
	}
}

long long getPow(long long n, long long p, long long m) {
	long long result = 1;
	while(p != 0) {
		if((p & 1) != 0) {
			result = (result * n) % m;
		}
		n = (n * n) % m;
		p >>= 1;
	}
	return result;
}

void build() {
	long long value = 1;
	rev[0] = rev[1] = value;
	for(long long i = 2; i < MAXN; i++) {
		value = (value * i) % MODULO;
		rev[i] = getPow(value, MODULO - 2, MODULO);
	}
}

int main() {
	build();
	while(true) {
		scanf("%lld%lld%d", &N, &D, &X);
		if(N == 0) break;
		solve();
	}
	return 0;
}